/*
 * stdfont.cpp
 * Copyright (C) 1997 - 2002 Bartosz Leopold Lis <bartoszl@ics.p.lodz.pl>
 */

/*
 * Here is the source code of the ``stdfont'' module.
 *
 * This module contains standard font for the ``banner'' program.
 */

#include "stdfont.h"

char_matrix c_a={ "      ",
                  " __   ",
                  "' _`\\ ",
                  "/'  | ",
                  "\\___\\ ",
                  "      ",
};
char_matrix c_b={ "|     ",
                  "|_    ",
                  "| `\\  ",
                  "|   ) ",
                  "|\\_/  ",
                  "      ",
};
char_matrix c_c={ "      ",
                  "      ",
                  " /~~\\ ",
                  "|     ",
                  "`\\__/ ",
                  "      ",
};
char_matrix c_d={ "    | ",
                  "   _| ",
                  " /' | ",
                  "(   | ",
                  "`\\_/| ",
                  "      ",
};
char_matrix c_e={ "      ",
                  "      ",
                  " /~~\\ ",
                  "|___/ ",
                  "`\\__, ",
                  "      ",
};
char_matrix c_f={ "    _ ",
                  "  /'  ",
                  " |    ",
                  "-+-   ",
                  " |    ",
                  " |    ",
};
char_matrix c_g={ "      ",
                  "      ",
                  " /~\\  ",
                  "(   | ",
                  "`\\__| ",
                  " __/' ",
};
char_matrix c_h={ "|     ",
                  "|_    ",
                  "| `\\  ",
                  "|   | ",
                  "|   | ",
                  "      ",
};
char_matrix c_i={ "  o   ",
                  " ___  ",
                  "  |   ",
                  "  |   ",
                  " _|_  ",
                  "      ",
};
char_matrix c_j={ "   o  ",
                  "  ___ ",
                  "   |  ",
                  "   |  ",
                  "   |  ",
                  "\\_/'  ",
};
char_matrix c_k={ "|     ",
                  "|     ",
                  "|  ,~ ",
                  "|-<   ",
                  "|  `\\ ",
                  "      ",
};
char_matrix c_l={ " |    ",
                  " |    ",
                  " |    ",
                  " |    ",
                  " `\\   ",
                  "      ",
};
char_matrix c_m={ "      ",
                  "      ",
                  "|^\\^\\ ",
                  "| | | ",
                  "| | \\ ",
                  "      ",
};
char_matrix c_n={ "      ",
                  "      ",
                  "|/~\\  ",
                  "|   | ",
                  "|   \\ ",
                  "      ",
};
char_matrix c_o={ "      ",
                  "      ",
                  " /~\\  ",
                  "(   ) ",
                  " \\_/  ",
                  "      ",
};
char_matrix c_p={ "      ",
                  "      ",
                  "|~~\\  ",
                  "|   ) ",
                  "|__/  ",
                  "|     ",
};
char_matrix c_q={ "      ",
                  "      ",
                  " /~|  ",
                  "(  |  ",
                  " \\_|  ",
                  "   |/ ",
};
char_matrix c_r={ "      ",
                  "      ",
                  "\\,'\\| ",
                  " |    ",
                  " |    ",
                  "      ",
};
char_matrix c_s={ "      ",
                  " ___  ",
                  "(   ` ",
                  " `\\.  ",
                  ".___) ",
                  "      ",
};
char_matrix c_t={ "      ",
                  "  |   ",
                  "--+-- ",
                  "  |   ",
                  "  `\\  ",
                  "      ",
};
char_matrix c_u={ "      ",
                  "      ",
                  "|   | ",
                  "|   | ",
                  "`\\__% ",
                  "      ",
};
char_matrix c_v={ "      ",
                  "      ",
                  "|   | ",
                  "|   | ",
                  "`\\./' ",
                  "      ",
};
char_matrix c_w={ "      ",
                  "      ",
                  "|   | ",
                  "| | | ",
                  "`.^.' ",
                  "      ",
};
char_matrix c_x={ "      ",
                  "      ",
                  "\\   / ",
                  " `/'  ",
                  "/' `\\ ",
                  "      ",
};
char_matrix c_y={ "      ",
                  "      ",
                  "|   | ",
                  "|   | ",
                  "`\\__| ",
                  " __/' ",
};
char_matrix c_z={ "      ",
                  "_____ ",
                  "    / ",
                  " ,/'  ",
                  "/____ ",
                  "      ",
};

char_matrix c_0={ " /~\\  ",
                  "|  /| ",
                  "| | | ",
                  "|/  | ",
                  " \\_/  ",
                  "      ",
};
char_matrix c_1={ " ,|   ",
                  "/ |   ",
                  "  |   ",
                  "  |   ",
                  "__|__ ",
                  "      ",
};
char_matrix c_2={ " /~\\  ",
                  "    | ",
                  "   /' ",
                  " /'   ",
                  "|___. ",
                  "      ",
};
char_matrix c_3={ "/~~\\  ",
                  "    ; ",
                  "  ~\\  ",
                  "    | ",
                  "\\__/  ",
                  "      ",
};
char_matrix c_4={ "  /|  ",
                  "/' |  ",
                  "---+- ",
                  "   |  ",
                  "   |  ",
                  "      ",
};
char_matrix c_5={ "|~~~  ",
                  "|     ",
                  "'~~\\  ",
                  "    | ",
                  "\\__/' ",
                  "      ",
};
char_matrix c_6={ " /~\\  ",
                  "|     ",
                  "|~~\\  ",
                  "|   | ",
                  " \\_/' ",
                  "      ",
};
char_matrix c_7={ "^~~~/ ",
                  "  /'  ",
                  "-+-   ",
                  " |    ",
                  " |    ",
                  "      ",
};
char_matrix c_8={ " /~\\  ",
                  "(   ) ",
                  " >-<  ",
                  "(   ) ",
                  " \\_/  ",
                  "      ",
};
char_matrix c_9={ " /~\\  ",
                  "(   | ",
                  " \\__| ",
                  "    | ",
                  " \\_/' ",
                  "      ",
};

char_matrix c_dot={ "      ",
                    "      ",
                    "      ",
                    "  _   ",
                    " (_)  ",
                    "      ",
};
char_matrix c_comma={ "      ",
                      "      ",
                      "      ",
                      "      ",
                      " ,~,  ",
                      " //   ",
};
char_matrix c_exclam={ " |~|  ",
                       "  #   ",
                       "  |   ",
                       "  _   ",
                       " (_)  ",
                       "      ",
};
char_matrix c_colon={ "      ",
                      "  _   ",
                      " (_)  ",
                      "  _   ",
                      " (_)  ",
                      "      ",
};
char_matrix c_semicolon={ "      ",
                          "  _   ",
                          " (_)  ",
                          "      ",
                          " ,~,  ",
                          " //   ",
};

char_matrix c_space={ "      ",
                      "      ",
                      "      ",
                      "      ",
                      "      ",
                      "      ",
};
char_matrix c_unknown={ "      ",
                        " ___  ",
                        "un!?! ",
                        "known ",
                        "?char ",
                        " ~~~  ",
};

void
init_default_font()
{
   int i;
   font_num=DEF_FONT_NUM;
   font_width=DEF_FONT_WIDTH;
   font_height=DEF_FONT_HEIGHT;
   for (i=0; i<font_num; ++i) font_arr[i]=&c_unknown;
   font_arr[' ']=&c_space;
   font_arr['a']=font_arr['A']=&c_a;
   font_arr['b']=font_arr['B']=&c_b;
   font_arr['c']=font_arr['C']=&c_c;
   font_arr['d']=font_arr['D']=&c_d;
   font_arr['e']=font_arr['E']=&c_e;
   font_arr['f']=font_arr['F']=&c_f;
   font_arr['g']=font_arr['G']=&c_g;
   font_arr['h']=font_arr['H']=&c_h;
   font_arr['i']=font_arr['I']=&c_i;
   font_arr['j']=font_arr['J']=&c_j;
   font_arr['k']=font_arr['K']=&c_k;
   font_arr['l']=font_arr['L']=&c_l;
   font_arr['m']=font_arr['M']=&c_m;
   font_arr['n']=font_arr['N']=&c_n;
   font_arr['o']=font_arr['O']=&c_o;
   font_arr['p']=font_arr['P']=&c_p;
   font_arr['q']=font_arr['Q']=&c_q;
   font_arr['r']=font_arr['R']=&c_r;
   font_arr['s']=font_arr['S']=&c_s;
   font_arr['t']=font_arr['T']=&c_t;
   font_arr['u']=font_arr['U']=&c_u;
   font_arr['v']=font_arr['V']=&c_v;
   font_arr['w']=font_arr['W']=&c_w;
   font_arr['x']=font_arr['X']=&c_x;
   font_arr['y']=font_arr['Y']=&c_y;
   font_arr['z']=font_arr['Z']=&c_z;
   font_arr['0']=&c_0;
   font_arr['1']=&c_1;
   font_arr['2']=&c_2;
   font_arr['3']=&c_3;
   font_arr['4']=&c_4;
   font_arr['5']=&c_5;
   font_arr['6']=&c_6;
   font_arr['7']=&c_7;
   font_arr['8']=&c_8;
   font_arr['9']=&c_9;
   font_arr['.']=&c_dot;
   font_arr[',']=&c_comma;
   font_arr[':']=&c_colon;
   font_arr[';']=&c_semicolon;
   font_arr['!']=&c_exclam;
}
